/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


/* SCR; 29.10.97; this file contains simple read/write (i.e. I/O) functions
 * that are operating-system dependent....in this case Win32 ONLY.
 * NOTE; Until all Win95 drivers are true 32-bit (i.e. use CreateFile())
 * we use defines here to bring in the DOS drivers.
 */

/* --------------------------------------------------------------------------
 * IMPORTANT; Read the notes on RegWidth in b_io.h
 *            DO NOT check the real connection within BestBasicRead() or Write()
 *            That could be recursive (and would be very bad).
 *            The handle connection check is a flag and thus OK.
 * -------------------------------------------------------------------------- */

#pragma warning( disable: 4115 4514)
#include <windows.h>
#pragma warning( default: 4115 4514)

#pragma warning( disable: 4201)
#include <winioctl.h>
#pragma warning( default: 4201)

#include <typedefs.h>

#include <b_hif.h>

#include <errcapi.h>
#include <session.h>

#include "b_io.h"
#include "hif.h"
#include "pci.h"
#include "lasterr.h"


#ifdef __BORLANDC__
#pragma inline
#endif


/* --------------------------------------------------------------------------
 * Reads a stream of bytes from the port...NO BYTE ORDERING DONE HERE !!!
 * This function has no knowledge of registers.
 * -------------------------------------------------------------------------- */

b_errtype BestBasicRead(
    b_handletype handle,
    b_int8 * pData,
    b_int32 NumBytes,
    b_int8 RegWidth)
{
  B_TRY_VARS;

  b_int32 BytesRead = 0, BytesLeft = 0;
  b_portnumtype OsHandle = handle_array[handle].portnumber;
  b_int32 result;

  B_TRY_BEGIN
  {
    if (NumBytes)
    {
      B_TRY_FAIL(BestIsHandleConnected(handle) ? B_E_OK : B_E_NOT_CONNECTED);

      assert(pData);
      assert(((NumBytes % RegWidth) == 0) && "Boundary violation in BestBasicRead()");

      /* must set (or at least check) the reg. width */
      (void) BestRegwidthSet(handle, RegWidth);

      switch (handle_array[handle].port)
      {
      case B_PORT_OFFLINE:
        memset(pData, 0, NumBytes);
        break;

      case B_PORT_FASTHIF:
        if (BestIsInBlockMode(handle))
        {
          /* use the block (direct) mode read */
          B_TRY_PROGRESS(BestHIFIoCtlRead(handle, pData,
              NumBytes, &BytesRead,
              (b_int32)IOCTL_HIF_READ_DIRECT));
          break;
        }

        /* NT FastHif Controlled IO is a deliberate flow into next case */

      case B_PORT_PCI_CONF:
      case B_PORT_PCI_IO:
      case B_PORT_RS232:
            BytesLeft=NumBytes;
            do 
            {
              result=ReadFile(OsHandle, pData, BytesLeft, &BytesRead, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                              Doesn't return after before having transfered all data, so normally no error
                                                                                 Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                        to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesRead==0))                /* This is only an error if no data is has been transfered */
              {
                B_TRY_PROGRESS(B_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesRead;
              pData+=BytesRead;
  
            } while (BytesLeft && BytesRead);
  
            if (BytesLeft) 
            {
              /* BytesRead==0 */
              B_TRY_FAIL(B_E_INTERNAL_RETURN);
            }
            break;

      default:
        B_TRY_ERROR(B_E_BAD_HANDLE);
      } 
    }
  }

  B_TRY_CATCH
  {
      DBG_ApiLastError;         /* no harm if error was not from Windows */
      BestLastErrorParamSet(handle, B_ERRPAR_1, B_EERR_READ_WRITE);
      B_TRY_RET = B_E_ERROR;
  }

  return B_TRY_RET;
}


/* --------------------------------------------------------------------------
 * Writes a stream of bytes to the port...NO BYTE ORDERING DONE HERE !!!
 * This function has no knowledge of registers.
 * -------------------------------------------------------------------------- */

b_errtype BestBasicWrite(
    b_handletype handle,
    b_int8 * pData,
    b_int32 NumBytes,
    b_int8 RegWidth)
{
  B_TRY_VARS;
  b_int32 BytesWritten = 0, BytesLeft = 0;
  b_portnumtype OsHandle = handle_array[handle].portnumber;
  b_int32 result;

  B_TRY_BEGIN
  {
    if (NumBytes)
    {
      B_TRY_FAIL(BestIsHandleConnected(handle) ? B_E_OK : B_E_NOT_CONNECTED);

      assert(pData);
      assert(((NumBytes % RegWidth) == 0) && "Boundary violation in BestBasicWrite()");

      /* must set (or at least check) the reg. width */
      (void) BestRegwidthSet(handle, RegWidth);

      switch (handle_array[handle].port)
      {
      case B_PORT_OFFLINE:
        break;

      case B_PORT_FASTHIF:
        if (BestIsInBlockMode(handle))
        {
          /* use the block (direct) mode write */
          B_TRY_PROGRESS(BestHIFIoCtlWrite(handle, pData,
              NumBytes, &BytesWritten,
              (b_int32)IOCTL_HIF_WRITE_DIRECT));
          break;
        }

        /* NT FastHif Controlled IO is a deliberate flow into next case */

      case B_PORT_PCI_CONF:
      case B_PORT_PCI_IO:
      case B_PORT_RS232:
          BytesLeft=NumBytes;
          do {
              result=WriteFile(OsHandle, pData, BytesLeft, &BytesWritten, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                                  Doesn't return after before having transfered all data, so normally no error
                                                                                     Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                            to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesWritten==0))                /* This is only an error if no data is has been transfered */
              {
                B_TRY_PROGRESS(B_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesWritten;
              pData+=BytesWritten;
          } while (BytesLeft && BytesWritten);
          
          if (BytesLeft)
          {
            /* BytesWritten==0 */
            B_TRY_ERROR(B_E_INTERNAL_RETURN);
          }
          break;

      default:
        B_TRY_ERROR(B_E_BAD_HANDLE);
      } /*lint !e788 ... not all enums used */

      B_TRY(BestCheckCallBack(handle));
      BestLastErrorParamSet(handle, B_ERRPAR_1, B_EERR_DRV_TIMEOUT);
      B_TRY_FAIL(BytesLeft == 0 ? B_E_OK : B_E_ERROR);
    }
  }

  B_TRY_CATCH
  {
    DBG_ApiLastError;         /* no harm if error was not from Windows */
    BestLastErrorParamSet(handle, B_ERRPAR_1, B_EERR_READ_WRITE);
    B_TRY_RET = B_E_ERROR;
  }

  return B_TRY_RET;
}
